function Figure6S1E()
% This script plots the data from Figure 6 - figure supplement 1E.

%==========================================================================
% Data without (top rows in each variable) and with (bottom rows in each variable)
% osmotic swelling:
CR9501_fix = [0.073989 0.090432 0.10582 0.09114 0.060626 0.099801 0.086814;
              0.17774 0.12783 0.23292 0.13893 0.11038 0.13698 0.1315];
neg_fix = [0.0097271 0.0094367 0.0070829 0.010293 0.010306 0.0085968;
           0.0067667 0.0068359 0.007602 0.015495 0.013819 0.017678];
CR9501 = [0.29452 0.16414 0.27427 0.33825;
          0.34687 0.34615 0.43466 0.54598];
neg = [0.025129 0.025526 0.014967 0.0078443;
       0.028632 0.017454 0.0079189 0.0041261];

q = [1:2];
plot(q,CR9501','-','Color',[0.8 0.8 0.8]); hold on;
plot(q,mean(CR9501'),'-k'); hold on;
q = q + 1.2;
plot(q,CR9501_fix','-','Color',[0.8 0.8 0.8]); hold on;
plot(q,mean(CR9501_fix'),'-k'); hold on;
q = q + 1.2;
plot(q,neg','-','Color',[0.8 0.8 0.8]); hold on;
plot(q,mean(neg'),'-k'); hold on;
q = q + 1.2;
plot(q,neg_fix','-','Color',[0.8 0.8 0.8]); hold on;
plot(q,mean(neg_fix'),'-k'); hold on;
%==========================================================================

%==========================================================================
% Calculate and plot the fold-enrichment in C3-positive particles +/-PFA:
R_f = CR9501_fix(2,:)./CR9501_fix(1,:);
U_f = 1+rand(size(R_f))/2;
R = CR9501(2,:)./CR9501(1,:);
U = 2+rand(size(R))/2;
figure; hold on;
plot(U_f,log2(R_f),'o',U,log2(R),'o','MarkerFaceColor',[0.7 0.7 0.7],...
    'MarkerEdgeColor',[0.7 0.7 0.7]);
plot([1 1.5],log2(mean(R_f))*[1 1],'k');
plot([2 2.5],log2(mean(R))*[1 1],'k');
ylim([-.5 2]); xlim([0.5 3]);
xticks([1.25 2.25]);
xticklabels({'+PFA','-PFA'});
ylabel('Fold-increase C3-positive particles (log_2)')
%==========================================================================

%==========================================================================
% Calculate and display p-values (paired sample t-test):
[h,p] = ttest(CR9501(1,:),CR9501(2,:));
disp(['p-value for CR9501 -PFA comparison: ',num2str(p)])
[h,p] = ttest(CR9501_fix(1,:),CR9501_fix(2,:));
disp(['p-value for CR9501 +PFA comparison: ',num2str(p)])
[h,p] = ttest(neg(1,:),neg(2,:));
disp(['p-value for -IgG -PFA comparison: ',num2str(p)])
[h,p] = ttest(neg_fix(1,:),neg_fix(2,:));
disp(['p-value for -IgG +PFA comparison: ',num2str(p)])

% Calculate and display p-value for +/-PFA comparison (two sample t-test):
[h,p] = ttest2(R,R_f);
disp(['p-value for +/-PFA comparison: ',num2str(p)])
%==========================================================================